/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc.video;

import com.ami.kvm.jviewer.soc.video.ChangeRgns;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AVICA2AU {
    public static final int MAX_X_RESOLUTION = 1800;
    public static final int MAX_Y_RESOLUTION = 1800;
    int comp_ix;
    int a1;
    int a2;
    int c2;
    int x2;
    int p_b2;
    int p_x1;
    int p_v;
    int p_d32;
    short x_pixel;
    short y_pixel;
    short m_xres;
    short m_yres;
    short[] m_scr1;
    short[] m_scr2;

    private byte abs_diff(byte z1, byte z2) {
        if (z1 > z2) {
            return (byte)(z1 - z2);
        }
        return (byte)(z2 - z1);
    }

    private byte R(int x) {
        return (byte)(x >> 10);
    }

    private byte G(int x) {
        return (byte)(x >> 5 & 0x1F);
    }

    private byte B(int x) {
        return (byte)(x & 0x1F);
    }

    private boolean tcheck(int x1, int x2, byte t) {
        byte _b2;
        byte _g2;
        byte _r2;
        byte _r1 = this.R(x1);
        if (t <= this.abs_diff(_r1, _r2 = this.R(x2))) {
            return false;
        }
        byte _g1 = this.G(x1);
        if (t <= this.abs_diff(_g1, _g2 = this.G(x2))) {
            return false;
        }
        byte _b1 = this.B(x1);
        return t > this.abs_diff(_b1, _b2 = this.B(x2));
    }

    private void update_avica_vars() {
        this.a1 = this.m_scr1[this.p_x1];
        this.a2 = this.m_scr2[this.p_v];
        this.c2 = this.m_scr2[this.p_b2];
        ++this.p_x1;
        ++this.p_b2;
        ++this.p_v;
        --this.p_d32;
        this.x_pixel = (short)(this.x_pixel + 1);
        if (this.x_pixel == this.m_xres) {
            this.x_pixel = 0;
            this.y_pixel = (short)(this.y_pixel + 1);
            this.a1 = 0;
            this.a2 = 0;
            this.c2 = 0;
            this.p_d32 += 2 * this.m_xres;
        }
    }

    private int ushort(short sval) {
        int usval = (sval & 0x8000) != 0 ? 32768 : 0;
        return usval + (sval & Short.MAX_VALUE);
    }

    public int avica2a_uncompress_32(short[] scr1, ByteBuffer p_comp_buf, int offset, int comp_size, short res_x, short res_y, byte thigh, short[] scr2, short[] p_dib, ChangeRgns p_change_list, int diff) throws ArrayIndexOutOfBoundsException {
        short end_row;
        this.m_xres = res_x;
        this.m_yres = res_y;
        this.m_scr1 = scr1;
        this.m_scr2 = scr2;
        this.a1 = 0;
        this.a2 = 0;
        this.c2 = 0;
        this.p_x1 = 1800;
        this.p_v = 1800;
        this.p_d32 = res_x - 1;
        this.p_b2 = 1800 - res_x;
        this.comp_ix = 0;
        this.x_pixel = 0;
        this.y_pixel = 0;
        short start_row = 0;
        p_comp_buf.order(ByteOrder.LITTLE_ENDIAN);
        p_comp_buf.position(offset);
        block2: while (this.comp_ix != comp_size) {
            int num_zero;
            this.x2 = this.ushort(p_comp_buf.getShort(this.comp_ix + offset));
            this.comp_ix += 2;
            if (this.x2 < 32768) {
                scr2[this.p_v] = (short)this.x2;
                p_dib[this.p_d32] = scr2[this.p_v];
                this.update_avica_vars();
                continue;
            }
            if (this.x2 == 32768) {
                scr2[this.p_v] = 0;
                p_dib[this.p_d32] = scr2[this.p_v];
                this.update_avica_vars();
                continue;
            }
            if (this.x2 <= 32768) continue;
            if (this.x2 >= 49152) {
                num_zero = (this.x2 & 0x3FFF) << 16;
                num_zero += this.ushort(p_comp_buf.getShort(this.comp_ix + offset));
                this.comp_ix += 2;
            } else {
                num_zero = this.x2 - 32768;
            }
            while (0 != num_zero) {
                if (this.a1 == this.a2) {
                    if (num_zero > res_x && (end_row = this.y_pixel) - start_row > 0) {
                        p_change_list.add(start_row, end_row);
                    }
                    try {
                        System.arraycopy(scr1, this.p_x1, scr2, this.p_v, num_zero);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.p_v += num_zero;
                    this.p_x1 += num_zero;
                    this.p_b2 += num_zero;
                    this.y_pixel = (short)(this.y_pixel + (this.x_pixel + num_zero) / res_x);
                    this.x_pixel = (short)((this.x_pixel + num_zero) % res_x);
                    this.p_d32 = this.y_pixel * (res_x - diff) + (res_x - 1 - this.x_pixel);
                    if (num_zero > res_x) {
                        start_row = this.y_pixel;
                    }
                    this.a1 = scr1[this.p_x1 - 1];
                    this.a2 = scr2[this.p_v - 1];
                    this.c2 = scr2[this.p_b2 - 1];
                    if (this.x_pixel == 0) {
                        this.a1 = 0;
                        this.a2 = 0;
                        this.c2 = 0;
                    }
                    num_zero = 0;
                    continue block2;
                }
                boolean ba = this.tcheck(this.a2, this.c2, thigh);
                if (ba) {
                    boolean bb = this.tcheck(scr2[this.p_b2], this.c2, thigh);
                    if (!bb) {
                        scr2[this.p_v] = scr2[this.p_b2];
                        p_dib[this.p_d32] = scr2[this.p_v];
                    } else {
                        scr2[this.p_v] = (short)this.a2;
                        p_dib[this.p_d32] = scr2[this.p_v];
                    }
                } else {
                    scr2[this.p_v] = (short)this.a2;
                    p_dib[this.p_d32] = scr2[this.p_v];
                }
                this.update_avica_vars();
                --num_zero;
            }
        }
        end_row = this.y_pixel;
        if (end_row - start_row > 0) {
            p_change_list.add(start_row, end_row);
        }
        p_comp_buf.order(ByteOrder.BIG_ENDIAN);
        return 0;
    }

    public int reverseImageBuffer(int res_x, int res_y, short[] p_dib, short[] p_rev) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(p_rev, 0, p_dib, 0, p_rev.length);
        int limit = res_x / 2;
        for (int y = 0; y < res_y; ++y) {
            int x = 0;
            int i = res_x - 1;
            while (x < limit) {
                int os = y * res_x;
                short t = p_dib[i + os];
                p_dib[i + os] = p_dib[x + os];
                p_dib[x + os] = t;
                ++x;
                --i;
            }
        }
        return 0;
    }
}

