/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.videorecord;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.RecorderToolBar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.util.TimerTask;

public class DisplayVideoDataTask
extends TimerTask {
    public static boolean run = true;
    private ISOCFrameHdr m_frameHdr;
    private byte[] videobuffer;
    private Date startTime;

    public DisplayVideoDataTask(byte[] buffer) {
        this.videobuffer = buffer;
        this.m_frameHdr = JViewerApp.getSoc_manager().getSOCFramehdr();
        if (JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getVideorecordapp().showInformationDialog("Video data is being recorded. Please wait until recording is completed.");
        }
    }

    @Override
    public void run() {
        byte[] timestamp = new byte[4];
        long Prevtimestamp = 0L;
        long Currtimestamp = 0L;
        byte[] code = new byte[1];
        byte[] header = new byte[this.m_frameHdr.getFrameHeadersize()];
        byte[] pad = new byte[3];
        int retval = 0;
        run = true;
        long diff = 0L;
        this.startTime = new Date(System.currentTimeMillis() / 1000L);
        FileInputStream fc_read = null;
        try {
            fc_read = new FileInputStream(JViewerApp.getInstance().getVideorecordapp().getVideotmpstorepath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        while (run) {
            ByteBuffer header_bb = ByteBuffer.wrap(header);
            header_bb.clear();
            try {
                retval = fc_read.read(timestamp);
                if (retval <= 0) {
                    run = false;
                    this.onenablemenu();
                    this.cancel();
                    continue;
                }
                ByteBuffer timestampbuffer = ByteBuffer.wrap(timestamp);
                timestampbuffer.order(ByteOrder.LITTLE_ENDIAN);
                Currtimestamp = timestampbuffer.getInt();
                if (Prevtimestamp == 0L) {
                    Prevtimestamp = Currtimestamp;
                }
                if ((retval = fc_read.read(code)) <= 0) {
                    run = false;
                    this.onenablemenu();
                    this.cancel();
                    continue;
                }
                retval = fc_read.read(pad);
                if (code[0] == 85) {
                    diff = Currtimestamp - Prevtimestamp;
                    if (diff > 0L) {
                        try {
                            Thread.sleep(diff * 1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    if (code[0] == 170 || code[0] == -86) continue;
                    if (code[0] == 102) {
                        JViewerApp.getInstance().getVidClnt().onBlankScreen();
                        continue;
                    }
                }
                Prevtimestamp = Currtimestamp;
                retval = fc_read.read(header);
                if (retval <= 0) {
                    run = false;
                    this.onenablemenu();
                    this.cancel();
                    continue;
                }
                header_bb.position(this.m_frameHdr.getFrameHeadersize());
                this.m_frameHdr.setHeader(header_bb);
                header_bb.position(0);
                if (this.m_frameHdr.getFrameSize() > 4608000) {
                    run = false;
                    this.onenablemenu();
                    this.cancel();
                    break;
                }
                byte[] framedata = new byte[this.m_frameHdr.getFrameSize()];
                retval = fc_read.read(framedata);
                if (retval <= 0 || retval < this.m_frameHdr.getFrameSize()) {
                    run = false;
                    this.onenablemenu();
                    this.cancel();
                    continue;
                }
                ByteBuffer buffer = ByteBuffer.allocate(this.m_frameHdr.getFrameSize() + this.m_frameHdr.getFrameHeadersize());
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.put(header, 0, this.m_frameHdr.getFrameHeadersize());
                buffer.put(framedata);
                buffer.position(this.m_frameHdr.getFrameSize() + this.m_frameHdr.getFrameHeadersize());
                JViewerApp.getInstance().getVidClnt().onNewFrame(buffer);
            }
            catch (Exception e) {}
        }
        try {
            fc_read.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void onenablemenu() {
        if (JViewer.isdownloadapp()) {
            this.calculateDuration();
        } else {
            RecorderToolBar toolBar = (RecorderToolBar)JViewerApp.getInstance().getM_wndFrame().toolbar;
            toolBar.enableButton(toolBar.replayButton);
        }
    }

    public void calculateDuration() {
        long duration = new Date(System.currentTimeMillis() / 1000L).getTime() - this.startTime.getTime();
        JViewerApp.getInstance().getVideorecordapp().setDuration(duration);
    }
}

