/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.SessionControllerFactory;

class FlashThread
extends Thread {
    String ip;
    String id;
    String password;
    String firmware;

    public FlashThread(String ip, String id, String password, String firmware) {
        this.ip = ip;
        this.id = id;
        this.password = password;
        this.firmware = firmware;
    }

    @Override
    public void run() {
        System.out.println("Flashing firmware to " + this.ip + "...");
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        SessionControllerFactory.createSessionController(config, ipmiRaritanOEMCommand);
        try {
            ipmiRaritanOEMCommand.flashFirmware(this.firmware);
            System.out.println("Flash frimware to " + this.ip + " Done");
        }
        catch (Exception ex2) {
            System.out.println("Flash frimware to " + this.ip + " Failed" + "(" + ex2.getMessage() + ")");
        }
    }
}

