/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;
import java.util.ArrayList;

public class CommandForGettingSELRecords
extends Command {
    @Override
    public Result execute(Host host) {
        SELInfo selInfo;
        ArrayList list;
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiSELCommand.setIPMIInterface(rmcp);
        ipmiSDRCommand.setIPMIInterface(rmcp);
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte[] aProductID = ipmiOEMCommand.getProductID();
        if (aProductID == null) {
            aProductID = new byte[2];
        }
        host.productID = aProductID;
        if (host.sdrRecords == null) {
            host.sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            host.sdrRecords = ipmiSDRCommand.getSDRs(host.sdrInfo.getRecordCount());
        }
        if ((list = ipmiSELCommand.getSELEntries((selInfo = ipmiSELCommand.getSELInfoModal()).getLogEntries())).size() != 0) {
            for (SELRecord item : list) {
            }
        } else {
            MessageCenter.getInstance().put(L.t("group.Get_SEL_Entry_failed"));
        }
        if (list != null) {
            result.booleanResult = true;
            result.description = result.description + "ok";
            host.selRecords = list;
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Get_SEL_Info_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get SEL Records";
    }
}

