/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMLANInterfaceCommand
extends SuperBladeCommand {
    public static final byte DEDICATED = 0;
    public static final byte SHARE = 1;
    public static final byte FAILOVER = 2;
    public byte lanType = (byte)-1;
    public byte currentLANType;

    @Override
    public boolean preValidate() {
        this.lanType = (byte)-1;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("0")) {
                this.lanType = 0;
            } else if (this.parameters[0].equalsIgnoreCase("1")) {
                this.lanType = 1;
            } else if (this.parameters[0].equalsIgnoreCase("2")) {
                this.lanType = (byte)2;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            this.currentLANType = ipmiAMIOEMCommand.getLANMode();
        }
        catch (Exception ex) {
            MOut.G(this).println("Not a supported device");
            this.statusCode = 153;
            return;
        }
        switch (this.lanType) {
            case 0: {
                ipmiAMIOEMCommand.setLANMode((byte)0);
                MOut.G(this).println("done");
                break;
            }
            case 1: {
                ipmiAMIOEMCommand.setLANMode((byte)1);
                MOut.G(this).println("done");
                break;
            }
            case 2: {
                ipmiAMIOEMCommand.setLANMode((byte)2);
                MOut.G(this).println("done");
                break;
            }
            default: {
                this.printLANType(this.currentLANType);
            }
        }
    }

    private void printLANType(byte type) {
        switch (type) {
            case 0: {
                MOut.G(this).println("Current LAN interface is [ Dedicated LAN ]");
                break;
            }
            case 1: {
                MOut.G(this).println("Current LAN interface is [ On Board LAN1 ]");
                break;
            }
            case 2: {
                MOut.G(this).println("Current LAN interface is [ Failover ]");
            }
        }
        MOut.G(this).println("\nParameter for setting:");
        MOut.G(this).println("0:Dedicated");
        MOut.G(this).println("1:On Board LAN1");
        MOut.G(this).println("2:Failover");
    }
}

