/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20AddPowerPolicyCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        int limit;
        byte id;
        if (this.parameters == null || this.parameters.length < 4) {
            MOut.G(this).println("addPowerPolicy <pID> <limit> <t> <p>");
            MOut.G(this).println("pID: Policy ID");
            MOut.G(this).println("limit: Policy Target Limit");
            MOut.G(this).println("t: Correction Time Limit (ms)");
            MOut.G(this).println("p: Statistics Reporting Period in seconds");
            MOut.G(this).println("");
            MOut.G(this).println("* domainID will be 0(Entire platform) for this command");
            MOut.G(this).println("ex: nm20 addPowerPolicy  1 100 6000 10");
            return;
        }
        int correctionTime = 60000;
        int reportingPeriod = 1;
        try {
            id = (byte)Integer.parseInt(this.parameters[0]);
            limit = Integer.parseInt(this.parameters[1]);
            correctionTime = Integer.parseInt(this.parameters[2]);
            reportingPeriod = Integer.parseInt(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        IPMINM20Command.NodeManagerPolicySetting policySetting = this.ipmiNM20Command.createNodeManagerPolicySetting();
        policySetting.domainID = (byte)16;
        policySetting.policyID = id;
        policySetting.policyConfig = (byte)16;
        policySetting.PolicyException = 1;
        ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, limit);
        ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, correctionTime);
        ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, limit);
        ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, reportingPeriod);
        try {
            this.ipmiNM20Command.setNodeManagerPolicy(policySetting);
            this.ipmiNM20Command.enableDisableNodeManagerPolicyControl((byte)5, (byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        MOut.G(this).println("Done");
    }
}

