/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMLimitCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters != null && this.parameters.length == 1) {
            int limit = 0;
            String para1 = this.parameters[0];
            try {
                limit = Integer.parseInt(para1);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                return;
            }
            IPMIDCMOEMCommand.NodeManagerPolicySetting policySetting = ipmiDCMOEMCommand.createNodeManagerPolicySetting();
            policySetting.domainID = 0;
            policySetting.policyID = (byte)32;
            policySetting.policyConfig = (byte)16;
            policySetting.PolicyException = 1;
            ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, limit);
            ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, 60000);
            ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, 0);
            ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, 1);
            try {
                ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)0, (byte)0, (byte)0);
                ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)4, (byte)0, (byte)32);
                ipmiDCMOEMCommand.setNodeManagerPolicy(policySetting);
                ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)1, (byte)0, (byte)0);
                ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)5, (byte)0, (byte)32);
            }
            catch (Exception ex) {
                MOut.G(this).print(ex.getMessage());
                return;
            }
            MOut.G(this).println("Done");
            return;
        }
        IPMIDCMOEMCommand.NodeManagerPolicy policy = null;
        try {
            policy = ipmiDCMOEMCommand.getNodeManagerPolicy((byte)0, (byte)32);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (policy == null) {
            MOut.G(this).println("Call getNodeManagerStatistics failed");
        }
        MOut.G(this).println("Power Limit = " + ByteUtility.twoBytesToIntLSB(policy.powerLimit) + " w");
    }
}

