/*
 * Decompiled with CFR 0.152.
 */
package supermicro.jviewer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SMCUtil {
    public static boolean isX64OS() {
        String osArch = System.getProperty("os.arch");
        return osArch.indexOf("64") != -1;
    }

    public static void loadLibrary(String library) {
        if (SMCUtil.isX64OS()) {
            System.loadLibrary(library + "7757x64");
        } else {
            System.loadLibrary(library + "7757");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadLib(String libName) throws IOException {
        String systemType = System.getProperty("os.name");
        String libExtension = System.getProperty("os.arch").indexOf("64") != -1 ? "7757x64" : "7757";
        String libFullName = systemType.startsWith("Windows") ? libName + libExtension + ".dll" : (systemType.startsWith("Linux") ? "lib" + libName + libExtension + ".so" : "lib" + libName + libExtension + ".jnilib");
        File extractedLibFile = new File(System.getProperty("java.io.tmpdir") + File.separator + libFullName);
        InputStream in = null;
        BufferedInputStream reader = null;
        FileOutputStream writer = null;
        try {
            in = SMCUtil.class.getResourceAsStream("/res/" + libFullName);
            if (in == null) {
                in = SMCUtil.class.getResourceAsStream(libFullName);
            }
            SMCUtil.class.getResource(libFullName);
            reader = new BufferedInputStream(in);
            writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[1024];
            while (reader.read(buffer) > 0) {
                writer.write(buffer);
                buffer = new byte[1024];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        System.load(System.getProperty("java.io.tmpdir") + File.separator + libFullName);
    }
}

